#import <Foundation/Foundation.h>
#import <OpenGLES/ES2/gl.h>
#import <OpenGLES/ES2/glext.h>

@interface GLProgram : NSObject 
{
    NSMutableArray  *attributes;
    NSMutableArray  *uniforms;
	GLuint vertShader, 
    fragShader;	
}

typedef enum {
    SIMPLE_VERTEX
} VertexShaderType;

typedef enum {
    SIMPLE_FRAGMENT,
    VIDEO2D_FRAGMENT
} FragmentShaderType;

@property (assign, nonatomic) GLuint program;

- (id)initWithVertexShader:(VertexShaderType) vType FragmentShader:(FragmentShaderType) fType;

-(void)addAttribute:(NSString *)attributeName;
- (GLuint)attributeIndex:(NSString *)attributeName;
- (GLuint)uniformIndex:(NSString *)uniformName;
- (BOOL)link;
- (void)use;

- (NSString *)vertexShaderLog;
- (NSString *)fragmentShaderLog;
- (NSString *)vertexShaderSource:(VertexShaderType) shaderType;
- (NSString *)fragmentShaderSource:(FragmentShaderType) shaderType;

- (NSString *)programLog;
- (void)validate;

@end
